#  ifdef COMPUTE_TYPETABLE_ID_FROM_MODULE_ID
	call	init_range_id
#  endif
	_set_undo_handler $undo_copying
	
	// Each node now has a colour associated with it.
	// 
	// For the moment it is assumed that pieces graph are allocated in successive
	// space.
	// 
	// Each site in the code where descP are copied in the string should be 
	// changed e.g. arrays. Look for '// also for array'.
# undef temp2

	movl	heapP,graph_start						// backup start of encoded graph
			
# define ML(x)				x##_ccn
# define ENTRY_LABEL		copy_next_node_ccn
# define ENTRY_LABEL_NODEP	copy_next_node_in_nodeP_ccn

# define OLD_COPY_PASS

copy_nodes_with_current_colour:
	movl	heapP,old_heapP
	
	jmp		ML(copy_next_node_in_nodeP)				// encode nodes having current colour
# define EXIT_LABEL		copy_done_current_colour_copied

# define COPY_PASS
# include "gts_copy.c"
# undef COPY_PASS

EXIT_LABEL:
# define newHeapP descP
	movl	heapP,newHeapP							// new heap pointer
	subl	old_heapP,newHeapP						// newHeapP = newHeapP - old_heapP
# define block_size newHeapP
	shll	$16,block_size

	movl	current_colour,%ecx
	call	MAKE_ID_FCT(lb_index_of_entry)			
	
	movl	(%ecx),%ecx
	andl	$0x0000fffc,%ecx
	orl		%ecx,block_size							// 1234; 12 = (partial) block size, 34 = block index
# define block_info block_size
	
	call	MAKE_ID_FBI(lb_alloc_entry)				// alloc block info entry

	movl	block_info,(%ecx)			
# undef newHeapP
# undef block_size

	cmpl	esp_backup,%esp
	je		copy_equally_coloured_nodes_finished
	
	// assumption:
	// - the stack contains only nodes which colour has not yet been
	//   current_colour NIET WAAR. Furthermore the copy algorithm leaves different
	//   colours than the current colour unmodified. Thus it is always
	//   a pointer to a sn.
	popl	nodeP
	movl	(nodeP),descP
	cmpl	heapP,descP							// descP <= heapP; can be removed once assumption holds
	jbe		EXIT_LABEL							// node has already been encoded	
		
# define new_current_colour %ecx
	decl	descP
	movl	SN_COLOUR(descP),new_current_colour	// get new current colour
	andl	$ ENSN_COLOUR_GET_COLOUR,new_current_colour
	movl	new_current_colour,current_colour
# undef temp

	jmp		copy_nodes_with_current_colour
# undef EXIT_LABEL
